#!/bin/sh

# capture_filename1        r3/channel0.cfile
# capture_filename2        r3/channel1.cfile
# output_base_filename    r3/out/out_8
# num_outputs             14
# secs_per_output         1.000000
# freq_source_hz          498000000.000000
# samplerate              250000.000000
# min_range               0
# max_range_km            600
# max_range               500
# window_time_sec         0
# window                  8192
# max_speed_airplane_kmph 900.000000
# max_doppler_hz          10756.858087
# max_doppler             0.043027
# ndoppler_bins           0
#usage: lt-mdvh-xambi [options] ref_file scatter_file
#    -o OUTPUT_FILENAME [default=eb-xambi.out]
#    -m MIN_RANGE [default=0]
#    -M MAX_RANGE [default=300]
#    -w CORRELATION_WINDOW_SIZE [default=2500]
#    -s NSAMPLES_TO_SKIP [default=0]
#    -d max_doppler (normalized: [0, +1/2)) [default=.0012]
#    -n ndoppler_bins [default=31]
#    ndoppler_bins must >= 1
#-Xd 0.043027 -Xn 0
./mdvh-xambi -o r3/out/out_8.0000.xref -m 0 -M 500 -w 8192 -s 0 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0000.xref r3/out/out_8_i.0000.exr
./plot_xambi_tool.m r3/out/out_8.0000.xref r3/out/out_8_i.0000.ppm
convert -resize 800%  r3/out/out_8_i.0000.ppm r3/out/out_8_i.0000.gif
./mdvh-xambi -o r3/out/out_8.0001.xref -m 0 -M 500 -w 8192 -s 250000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0001.xref r3/out/out_8_i.0001.exr
./plot_xambi_tool.m r3/out/out_8.0001.xref r3/out/out_8_i.0001.ppm
convert -resize 800%  r3/out/out_8_i.0001.ppm r3/out/out_8_i.0001.gif
./mdvh-xambi -o r3/out/out_8.0002.xref -m 0 -M 500 -w 8192 -s 500000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0002.xref r3/out/out_8_i.0002.exr
./plot_xambi_tool.m r3/out/out_8.0002.xref r3/out/out_8_i.0002.ppm
convert -resize 800%  r3/out/out_8_i.0002.ppm r3/out/out_8_i.0002.gif
./mdvh-xambi -o r3/out/out_8.0003.xref -m 0 -M 500 -w 8192 -s 750000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0003.xref r3/out/out_8_i.0003.exr
./plot_xambi_tool.m r3/out/out_8.0003.xref r3/out/out_8_i.0003.ppm
convert -resize 800%  r3/out/out_8_i.0003.ppm r3/out/out_8_i.0003.gif
./mdvh-xambi -o r3/out/out_8.0004.xref -m 0 -M 500 -w 8192 -s 1000000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0004.xref r3/out/out_8_i.0004.exr
./plot_xambi_tool.m r3/out/out_8.0004.xref r3/out/out_8_i.0004.ppm
convert -resize 800%  r3/out/out_8_i.0004.ppm r3/out/out_8_i.0004.gif
./mdvh-xambi -o r3/out/out_8.0005.xref -m 0 -M 500 -w 8192 -s 1250000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0005.xref r3/out/out_8_i.0005.exr
./plot_xambi_tool.m r3/out/out_8.0005.xref r3/out/out_8_i.0005.ppm
convert -resize 800%  r3/out/out_8_i.0005.ppm r3/out/out_8_i.0005.gif
./mdvh-xambi -o r3/out/out_8.0006.xref -m 0 -M 500 -w 8192 -s 1500000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0006.xref r3/out/out_8_i.0006.exr
./plot_xambi_tool.m r3/out/out_8.0006.xref r3/out/out_8_i.0006.ppm
convert -resize 800%  r3/out/out_8_i.0006.ppm r3/out/out_8_i.0006.gif
./mdvh-xambi -o r3/out/out_8.0007.xref -m 0 -M 500 -w 8192 -s 1750000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0007.xref r3/out/out_8_i.0007.exr
./plot_xambi_tool.m r3/out/out_8.0007.xref r3/out/out_8_i.0007.ppm
convert -resize 800%  r3/out/out_8_i.0007.ppm r3/out/out_8_i.0007.gif
./mdvh-xambi -o r3/out/out_8.0008.xref -m 0 -M 500 -w 8192 -s 2000000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0008.xref r3/out/out_8_i.0008.exr
./plot_xambi_tool.m r3/out/out_8.0008.xref r3/out/out_8_i.0008.ppm
convert -resize 800%  r3/out/out_8_i.0008.ppm r3/out/out_8_i.0008.gif
./mdvh-xambi -o r3/out/out_8.0009.xref -m 0 -M 500 -w 8192 -s 2250000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0009.xref r3/out/out_8_i.0009.exr
./plot_xambi_tool.m r3/out/out_8.0009.xref r3/out/out_8_i.0009.ppm
convert -resize 800%  r3/out/out_8_i.0009.ppm r3/out/out_8_i.0009.gif
./mdvh-xambi -o r3/out/out_8.0010.xref -m 0 -M 500 -w 8192 -s 2500000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0010.xref r3/out/out_8_i.0010.exr
./plot_xambi_tool.m r3/out/out_8.0010.xref r3/out/out_8_i.0010.ppm
convert -resize 800%  r3/out/out_8_i.0010.ppm r3/out/out_8_i.0010.gif
./mdvh-xambi -o r3/out/out_8.0011.xref -m 0 -M 500 -w 8192 -s 2750000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0011.xref r3/out/out_8_i.0011.exr
./plot_xambi_tool.m r3/out/out_8.0011.xref r3/out/out_8_i.0011.ppm
convert -resize 800%  r3/out/out_8_i.0011.ppm r3/out/out_8_i.0011.gif
./mdvh-xambi -o r3/out/out_8.0012.xref -m 0 -M 500 -w 8192 -s 3000000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0012.xref r3/out/out_8_i.0012.exr
./plot_xambi_tool.m r3/out/out_8.0012.xref r3/out/out_8_i.0012.ppm
convert -resize 800%  r3/out/out_8_i.0012.ppm r3/out/out_8_i.0012.gif
./mdvh-xambi -o r3/out/out_8.0013.xref -m 0 -M 500 -w 8192 -s 3250000 -d 0.0 -n 1 r3/channel0.cfile r3/channel1.cfile
./plot_xambi_tool_pfs.m r3/out/out_8.0013.xref r3/out/out_8_i.0013.exr
./plot_xambi_tool.m r3/out/out_8.0013.xref r3/out/out_8_i.0013.ppm
convert -resize 800%  r3/out/out_8_i.0013.ppm r3/out/out_8_i.0013.gif
gifsicle -d 50 r3/out/out_8_i.0000.gif r3/out/out_8_i.0001.gif r3/out/out_8_i.0002.gif r3/out/out_8_i.0003.gif r3/out/out_8_i.0004.gif r3/out/out_8_i.0005.gif r3/out/out_8_i.0006.gif r3/out/out_8_i.0007.gif r3/out/out_8_i.0008.gif r3/out/out_8_i.0009.gif r3/out/out_8_i.0010.gif r3/out/out_8_i.0011.gif r3/out/out_8_i.0012.gif r3/out/out_8_i.0013.gif >r3/out/out_8_animated.gif
