#!/usr/bin/env python

import sys
import math

def main():
    capture_filename="dvbt_indoor_chan24_amersfoort_RA_s15_f498M_g35-8M-cfloat.raw"
    output_base_filename="out_dvbt_chan24_amersfoort_6/dvbt_chan24_amersfoort_6"
    freq_source_hz=498.0e6 
    secs_per_output=1.0
    num_outputs=14
    min_range=0
    ndoppler_bins=1024
    samplerate = 8.0e6 #samples / second
    #window_time=1.0 #seconds
    #window = int(window_time*samplerate) = 8000000
    # take nearest power of 2
    window = 8388608
    window_time_sec=float(window)/samplerate

    c = 3.0e8 # speed of light in m/sec

    max_range_km=2*300
    max_range_m=1.0e3*max_range_km
    max_range_secs=max_range_m/c
    max_range=int(max_range_secs*samplerate)

    max_speed_airplane_kmph = 900.0 #km/hour
    max_speed_airplane_mps  = max_speed_airplane_kmph*3.6 # m/sec
    max_doppler_hz = 2.0*freq_source_hz * (math.sqrt((c + max_speed_airplane_mps)/(c - max_speed_airplane_mps))-1.0)
    max_doppler=max_doppler_hz/samplerate
    sys.stdout.write("#!/bin/sh\n")
    sys.stdout.write("\n")
    sys.stdout.write("# capture_filename        %s\n" % (capture_filename))
    sys.stdout.write("# output_base_filename    %s\n" % (output_base_filename))
    sys.stdout.write("# num_outputs             %d\n" % (num_outputs))
    sys.stdout.write("# secs_per_output         %f\n" % (secs_per_output))
    sys.stdout.write("# freq_source_hz          %f\n" % (freq_source_hz))
    sys.stdout.write("# samplerate              %f\n" % (samplerate))
    sys.stdout.write("# min_range               %i\n" % (min_range))
    sys.stdout.write("# max_range_km            %i\n" % (max_range_km))
    sys.stdout.write("# max_range               %i\n" % (max_range))
    sys.stdout.write("# window_time_sec         %i\n" % (window_time_sec))
    sys.stdout.write("# window                  %i\n" % (window))
    sys.stdout.write("# max_speed_airplane_kmph %f\n" % (max_speed_airplane_kmph))
    sys.stdout.write("# max_doppler_hz          %f\n" % (max_doppler_hz))
    sys.stdout.write("# max_doppler             %f\n" % (max_doppler))
    sys.stdout.write("# ndoppler_bins           %i\n" % (ndoppler_bins))
    sys.stdout.write("\n")
    #window = 250000
    #max_range = 99
    #./mdvh-xambi
    #usage: lt-mdvh-xambi [options] ref_file scatter_file
    #    -o OUTPUT_FILENAME [default=eb-xambi.out]
    #    -m MIN_RANGE [default=0]
    #    -M MAX_RANGE [default=300]
    #    -w CORRELATION_WINDOW_SIZE [default=2500]
    #    -s NSAMPLES_TO_SKIP [default=0]
    #    -d max_doppler (normalized: [0, +1/2)) [default=.0012]
    #    -n ndoppler_bins [default=31]

    gifs = []
    nsamples_to_skip=0

    for t in range(0, int(float(num_outputs*secs_per_output)), int(secs_per_output)):
        #sim_fn  = "sim.%04d" % (t,)
        xref_fn = "%s.%04d.xref" % (output_base_filename,t,)
        exr_fn  = "%s_i.%04d.exr" % (output_base_filename,t,)
        ppm_fn  = "%s_i.%04d.ppm" % (output_base_filename,t,)
        gif_fn  = "%s_i.%04d.gif" % (output_base_filename,t,)

        gifs.append(gif_fn)
        
        sys.stdout.write("./mdvh-xambi -o %s -m %d -M %d -w %d -s %d -d %f -n %d %s %s\n" % (
                         xref_fn, min_range,max_range,window,nsamples_to_skip,max_doppler,ndoppler_bins,capture_filename,capture_filename))

        #sys.stdout.write("./sim-airplane2 rfm -o %s -S %d\n" % (sim_fn, t))
        #sys.stdout.write("./eb-xambi -o %s -M %d -w %d -d 0.0002 rfm %s\n" % (
        #    xref_fn, max_range, window, sim_fn))
        sys.stdout.write("./plot_xambi_tool_pfs.m %s %s\n" % (xref_fn, exr_fn))
        sys.stdout.write("./plot_xambi_tool.m %s %s\n" % (xref_fn, ppm_fn))
        sys.stdout.write("convert -resize 800%% %s %s\n" % (ppm_fn, gif_fn))
        nsamples_to_skip=nsamples_to_skip+int(float(secs_per_output*samplerate))

    sys.stdout.write("gifsicle -d 50 %s >%s_animated.gif\n" % (' '.join(gifs),output_base_filename))

if __name__ == '__main__':
    main()
